---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, équilibrer les colonnes, composition en colonnes, 
              mise en page des colonnes
---

# Comment équilibrer les colonnes de texte en fin de document ?

L'option `twocolumn` des classes standard oblige LaTeX à présenter le texte d'un document sur deux colonnes. 
Cependant, la dernière page du document se termine généralement par des colonnes de longueurs différentes. 
Et rares sont ceux qui apprécient des colonnes déséquilibrées. En voici un exemple :

```
\documentclass[french,twocolumn]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte

\begin{document}
\lipsum[1-4] 
\end{document}
```

L'utilisateur doit être conscient que chacune des extensions évoquée par la suite pour résoudre ce problème 
est susceptible d'être perturbée en présence de flottants : 
si des problèmes surviennent, un réglage manuel des flottants dans le document pourra être nécessaire. 
C'est cette difficulté qui a conduit l'auteur de <ctanpkg:multicol>, présenté ci-après, 
à supprimer les flottants à une seule colonne.


## Avec des commandes de bases

Une solution manuelle consiste à insérer la commande `\pagebreak` à l'endroit approprié sur la dernière page. 
Si cette solution produit le bon effet, elle plait rarement, 
surtout si la dernière page est composée de texte généré automatiquement (par exemple, la bibliographie ou l'index) 
car il est alors difficile d'insérer la commande.


## Avec l'extension <ctanpkg:multicol>

Une des solutions au problème revient à utiliser l'extension <ctanpkg:multicol> au lieu de l'option `twocolumn`. 
En effet, <ctanpkg:multicol> équilibre par défaut les colonnes sur la dernière page. 

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte
  \usepackage{multicol}

\begin{document}
\begin{multicols}{2}
\lipsum[1-4] 
\end{multicols}
\end{document}
```

Cependant, ce choix a un coût : 
la routine de sortie particulière de <ctanpkg:multicol> interdit l'utilisation de flottants au sein d'une colonne, 
bien qu'elle autorise toujours les flottants sur la pleine largeur de la page 
(par exemple, avec l'environnement `figure*`).


## Avec l'extension <ctanpkg:flushend>

L'extension <ctanpkg:flushend> offre une solution à ce problème avec un code un peu sulfureux 
car modifiant l'une des parties les plus complexes du noyau LaTeX sans déployer aucune des règles de prudence décrites pour 
[corriger des commandes](/2_programmation/macros/patcher_une_commande_existante). 
L'extension ne change le comportement de LaTeX qu'à la fin du document où une commande dédiée permet d'équilibrer les colonnes finales. 

```
\documentclass[french,twocolumn]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte
  \usepackage{flushend}

\begin{document}
\lipsum[1-4] 
\end{document}
```

En complément, d'autres extensions liées à <ctanpkg:flushend> fournissent des moyens pour insérer des éléments 
sur la pleine largeur de la page dans des documents à deux colonnes.


## Avec l'extension <ctanpkg:balance>

L'extension <ctanpkg:balance> modifie également la routine de sortie 
(de manière sans doute plus prudente que <ctanpkg:flushend>).

Le chargement de l'extension ne suffit pas à obtenir l'équilibrage des colonnes : 
il faut utiliser la commande `\balance` afin de déclencher le mécanisme. 
La [documentation de l'extension](texdoc:balance) indique en effet que la modification de la routine de sortie ne doit pas être faite à la légère 
et pourrait en particulier parasiter des versions futures de LaTeX.
L'auteur de l'extension indique d'ailleurs que l'extension <ctanpkg:multicol> est sans doute préférable à la sienne.

```
\documentclass[french,twocolumn]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte
  \usepackage{balance}

\begin{document}
\balance
\lipsum[1-4] 
\end{document}
```


## Avec l'extension <ctanpkg:pbalance>

L'extension <ctanpkg:pbalance> (*P* comme "poor man's balance") 
essaie de résoudre les limitations des précédentes solutions concernant les flottants. 
Elle devrait être "sûre" (les modifications de la routine de sortie sont minimes) et fonctionner sans intervention de l'utilisateur. 

```
\documentclass[french,twocolumn]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte
  \usepackage{pbalance}

\begin{document}
\lipsum[1-4] 
\end{document}
```

Cependant, elle a son propre lot d'avertissements (consultez [sa documentation](texdoc:pbalance)). 
Les plus importants sont que :

- elle reste une extension récente (2020) et, par conséquent, elle a été très peu testée ;
- elle exige des passes LaTeX supplémentaires (jusqu'à trois dans certains cas).

:::{sources}
[Balancing columns at the end of a document](faquk:FAQ-balance)
:::
