"""add "parent_node_id" and "linked_mode_id" to PubsubNode

Revision ID: ece2a6d7e4bb
Revises: 8db042adb973
Create Date: 2025-08-16 16:47:48.242973

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "ece2a6d7e4bb"
down_revision = "8db042adb973"
branch_labels = None
depends_on = None


def upgrade():
    with op.batch_alter_table("pubsub_nodes", schema=None) as batch_op:
        batch_op.add_column(sa.Column("linked_node_id", sa.Integer(), nullable=True))
        batch_op.add_column(sa.Column("parent_node_id", sa.Integer(), nullable=True))
        batch_op.create_foreign_key(
            batch_op.f("fk_pubsub_nodes_parent_node_id_pubsub_nodes"),
            "pubsub_nodes",
            ["parent_node_id"],
            ["id"],
            ondelete="CASCADE",
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_pubsub_nodes_linked_node_id_pubsub_nodes"),
            "pubsub_nodes",
            ["linked_node_id"],
            ["id"],
            ondelete="CASCADE",
        )


def downgrade():
    with op.batch_alter_table("pubsub_nodes", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_pubsub_nodes_linked_node_id_pubsub_nodes"), type_="foreignkey"
        )
        batch_op.drop_constraint(
            batch_op.f("fk_pubsub_nodes_parent_node_id_pubsub_nodes"), type_="foreignkey"
        )
        batch_op.drop_column("parent_node_id")
        batch_op.drop_column("linked_node_id")
