/*
 * Copyright (c) 1993-2017, NVIDIA CORPORATION. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


#ifndef _clC37e_h_
#define _clC37e_h_

// class methods
#define NVC37E_UPDATE                                                           (0x00000200)
#define NVC37E_UPDATE_INTERLOCK_WITH_WIN_IMM                                    12:12
#define NVC37E_UPDATE_INTERLOCK_WITH_WIN_IMM_DISABLE                            (0x00000000)
#define NVC37E_UPDATE_INTERLOCK_WITH_WIN_IMM_ENABLE                             (0x00000001)
#define NVC37E_SET_SEMAPHORE_CONTROL                                            (0x0000020C)
#define NVC37E_SET_SEMAPHORE_CONTROL_OFFSET                                     7:0
#define NVC37E_SET_SEMAPHORE_ACQUIRE                                            (0x00000210)
#define NVC37E_SET_SEMAPHORE_ACQUIRE_VALUE                                      31:0
#define NVC37E_SET_SEMAPHORE_RELEASE                                            (0x00000214)
#define NVC37E_SET_SEMAPHORE_RELEASE_VALUE                                      31:0
#define NVC37E_SET_CONTEXT_DMA_SEMAPHORE                                        (0x00000218)
#define NVC37E_SET_CONTEXT_DMA_SEMAPHORE_HANDLE                                 31:0
#define NVC37E_SET_CONTEXT_DMA_NOTIFIER                                         (0x0000021C)
#define NVC37E_SET_CONTEXT_DMA_NOTIFIER_HANDLE                                  31:0
#define NVC37E_SET_NOTIFIER_CONTROL                                             (0x00000220)
#define NVC37E_SET_NOTIFIER_CONTROL_MODE                                        0:0
#define NVC37E_SET_NOTIFIER_CONTROL_MODE_WRITE                                  (0x00000000)
#define NVC37E_SET_NOTIFIER_CONTROL_MODE_WRITE_AWAKEN                           (0x00000001)
#define NVC37E_SET_NOTIFIER_CONTROL_OFFSET                                      11:4
#define NVC37E_SET_SIZE                                                         (0x00000224)
#define NVC37E_SET_SIZE_WIDTH                                                   15:0
#define NVC37E_SET_SIZE_HEIGHT                                                  31:16
#define NVC37E_SET_STORAGE                                                      (0x00000228)
#define NVC37E_SET_STORAGE_BLOCK_HEIGHT                                         3:0
#define NVC37E_SET_STORAGE_BLOCK_HEIGHT_NVD_BLOCK_HEIGHT_ONE_GOB                (0x00000000)
#define NVC37E_SET_STORAGE_BLOCK_HEIGHT_NVD_BLOCK_HEIGHT_TWO_GOBS               (0x00000001)
#define NVC37E_SET_STORAGE_BLOCK_HEIGHT_NVD_BLOCK_HEIGHT_FOUR_GOBS              (0x00000002)
#define NVC37E_SET_STORAGE_BLOCK_HEIGHT_NVD_BLOCK_HEIGHT_EIGHT_GOBS             (0x00000003)
#define NVC37E_SET_STORAGE_BLOCK_HEIGHT_NVD_BLOCK_HEIGHT_SIXTEEN_GOBS           (0x00000004)
#define NVC37E_SET_STORAGE_BLOCK_HEIGHT_NVD_BLOCK_HEIGHT_THIRTYTWO_GOBS         (0x00000005)
#define NVC37E_SET_STORAGE_MEMORY_LAYOUT                                        4:4
#define NVC37E_SET_STORAGE_MEMORY_LAYOUT_BLOCKLINEAR                            (0x00000000)
#define NVC37E_SET_STORAGE_MEMORY_LAYOUT_PITCH                                  (0x00000001)
#define NVC37E_SET_PARAMS                                                       (0x0000022C)
#define NVC37E_SET_PARAMS_FORMAT                                                7:0
#define NVC37E_SET_PARAMS_FORMAT_I8                                             (0x0000001E)
#define NVC37E_SET_PARAMS_FORMAT_R4G4B4A4                                       (0x0000002F)
#define NVC37E_SET_PARAMS_FORMAT_R5G6B5                                         (0x000000E8)
#define NVC37E_SET_PARAMS_FORMAT_A1R5G5B5                                       (0x000000E9)
#define NVC37E_SET_PARAMS_FORMAT_R5G5B5A1                                       (0x0000002E)
#define NVC37E_SET_PARAMS_FORMAT_A8R8G8B8                                       (0x000000CF)
#define NVC37E_SET_PARAMS_FORMAT_X8R8G8B8                                       (0x000000E6)
#define NVC37E_SET_PARAMS_FORMAT_A8B8G8R8                                       (0x000000D5)
#define NVC37E_SET_PARAMS_FORMAT_X8B8G8R8                                       (0x000000F9)
#define NVC37E_SET_PARAMS_FORMAT_A2R10G10B10                                    (0x000000DF)
#define NVC37E_SET_PARAMS_FORMAT_A2B10G10R10                                    (0x000000D1)
#define NVC37E_SET_PARAMS_FORMAT_X2BL10GL10RL10_XRBIAS                          (0x00000022)
#define NVC37E_SET_PARAMS_FORMAT_X2BL10GL10RL10_XVYCC                           (0x00000024)
#define NVC37E_SET_PARAMS_FORMAT_R16_G16_B16_A16_NVBIAS                         (0x00000023)
#define NVC37E_SET_PARAMS_FORMAT_R16_G16_B16_A16                                (0x000000C6)
#define NVC37E_SET_PARAMS_FORMAT_RF16_GF16_BF16_AF16                            (0x000000CA)
#define NVC37E_SET_PARAMS_FORMAT_Y8_U8__Y8_V8_N422                              (0x00000028)
#define NVC37E_SET_PARAMS_FORMAT_U8_Y8__V8_Y8_N422                              (0x00000029)
#define NVC37E_SET_PARAMS_FORMAT_Y8___U8V8_N444                                 (0x00000035)
#define NVC37E_SET_PARAMS_FORMAT_Y8___U8V8_N422                                 (0x00000036)
#define NVC37E_SET_PARAMS_FORMAT_Y8___U8V8_N422R                                (0x00000037)
#define NVC37E_SET_PARAMS_FORMAT_Y8___V8U8_N420                                 (0x00000038)
#define NVC37E_SET_PARAMS_FORMAT_Y8___U8___V8_N444                              (0x0000003A)
#define NVC37E_SET_PARAMS_FORMAT_Y8___U8___V8_N420                              (0x0000003B)
#define NVC37E_SET_PARAMS_FORMAT_Y10___U10V10_N444                              (0x00000055)
#define NVC37E_SET_PARAMS_FORMAT_Y10___U10V10_N422                              (0x00000056)
#define NVC37E_SET_PARAMS_FORMAT_Y10___U10V10_N422R                             (0x00000057)
#define NVC37E_SET_PARAMS_FORMAT_Y10___V10U10_N420                              (0x00000058)
#define NVC37E_SET_PARAMS_FORMAT_Y10___U10___V10_N444                           (0x0000005A)
#define NVC37E_SET_PARAMS_FORMAT_Y10___U10___V10_N420                           (0x0000005B)
#define NVC37E_SET_PARAMS_FORMAT_Y12___U12V12_N444                              (0x00000075)
#define NVC37E_SET_PARAMS_FORMAT_Y12___U12V12_N422                              (0x00000076)
#define NVC37E_SET_PARAMS_FORMAT_Y12___U12V12_N422R                             (0x00000077)
#define NVC37E_SET_PARAMS_FORMAT_Y12___V12U12_N420                              (0x00000078)
#define NVC37E_SET_PARAMS_FORMAT_Y12___U12___V12_N444                           (0x0000007A)
#define NVC37E_SET_PARAMS_FORMAT_Y12___U12___V12_N420                           (0x0000007B)
#define NVC37E_SET_PARAMS_COLOR_SPACE                                           9:8
#define NVC37E_SET_PARAMS_COLOR_SPACE_RGB                                       (0x00000000)
#define NVC37E_SET_PARAMS_COLOR_SPACE_YUV_601                                   (0x00000001)
#define NVC37E_SET_PARAMS_COLOR_SPACE_YUV_709                                   (0x00000002)
#define NVC37E_SET_PARAMS_COLOR_SPACE_YUV_2020                                  (0x00000003)
#define NVC37E_SET_PARAMS_INPUT_RANGE                                           13:12
#define NVC37E_SET_PARAMS_INPUT_RANGE_BYPASS                                    (0x00000000)
#define NVC37E_SET_PARAMS_INPUT_RANGE_LIMITED                                   (0x00000001)
#define NVC37E_SET_PARAMS_INPUT_RANGE_FULL                                      (0x00000002)
#define NVC37E_SET_PARAMS_UNDERREPLICATE                                        16:16
#define NVC37E_SET_PARAMS_UNDERREPLICATE_DISABLE                                (0x00000000)
#define NVC37E_SET_PARAMS_UNDERREPLICATE_ENABLE                                 (0x00000001)
#define NVC37E_SET_PARAMS_DE_GAMMA                                              21:20
#define NVC37E_SET_PARAMS_DE_GAMMA_NONE                                         (0x00000000)
#define NVC37E_SET_PARAMS_DE_GAMMA_SRGB                                         (0x00000001)
#define NVC37E_SET_PARAMS_DE_GAMMA_YUV8_10                                      (0x00000002)
#define NVC37E_SET_PARAMS_DE_GAMMA_YUV12                                        (0x00000003)
#define NVC37E_SET_PARAMS_CSC                                                   17:17
#define NVC37E_SET_PARAMS_CSC_DISABLE                                           (0x00000000)
#define NVC37E_SET_PARAMS_CSC_ENABLE                                            (0x00000001)
#define NVC37E_SET_PARAMS_CLAMP_BEFORE_BLEND                                    18:18
#define NVC37E_SET_PARAMS_CLAMP_BEFORE_BLEND_DISABLE                            (0x00000000)
#define NVC37E_SET_PARAMS_CLAMP_BEFORE_BLEND_ENABLE                             (0x00000001)
#define NVC37E_SET_PARAMS_SWAP_UV                                               19:19
#define NVC37E_SET_PARAMS_SWAP_UV_DISABLE                                       (0x00000000)
#define NVC37E_SET_PARAMS_SWAP_UV_ENABLE                                        (0x00000001)
#define NVC37E_SET_PLANAR_STORAGE(b)                                            (0x00000230 + (b)*0x00000004)
#define NVC37E_SET_PLANAR_STORAGE_PITCH                                         12:0
#define NVC37E_SET_CONTEXT_DMA_ISO(b)                                           (0x00000240 + (b)*0x00000004)
#define NVC37E_SET_CONTEXT_DMA_ISO_HANDLE                                       31:0
#define NVC37E_SET_OFFSET(b)                                                    (0x00000260 + (b)*0x00000004)
#define NVC37E_SET_OFFSET_ORIGIN                                                31:0
#define NVC37E_SET_POINT_IN(b)                                                  (0x00000290 + (b)*0x00000004)
#define NVC37E_SET_POINT_IN_X                                                   15:0
#define NVC37E_SET_POINT_IN_Y                                                   31:16
#define NVC37E_SET_SIZE_IN                                                      (0x00000298)
#define NVC37E_SET_SIZE_IN_WIDTH                                                14:0
#define NVC37E_SET_SIZE_IN_HEIGHT                                               30:16
#define NVC37E_SET_SIZE_OUT                                                     (0x000002A4)
#define NVC37E_SET_SIZE_OUT_WIDTH                                               14:0
#define NVC37E_SET_SIZE_OUT_HEIGHT                                              30:16
#define NVC37E_SET_CONTROL_INPUT_LUT                                            (0x000002B0)
#define NVC37E_SET_CONTROL_INPUT_LUT_SIZE                                       1:0
#define NVC37E_SET_CONTROL_INPUT_LUT_SIZE_SIZE_257                              (0x00000000)
#define NVC37E_SET_CONTROL_INPUT_LUT_SIZE_SIZE_1025                             (0x00000002)
#define NVC37E_SET_CONTROL_INPUT_LUT_RANGE                                      5:4
#define NVC37E_SET_CONTROL_INPUT_LUT_RANGE_UNITY                                (0x00000000)
#define NVC37E_SET_CONTROL_INPUT_LUT_RANGE_XRBIAS                               (0x00000001)
#define NVC37E_SET_CONTROL_INPUT_LUT_RANGE_XVYCC                                (0x00000002)
#define NVC37E_SET_CONTROL_INPUT_LUT_OUTPUT_MODE                                9:8
#define NVC37E_SET_CONTROL_INPUT_LUT_OUTPUT_MODE_INDEX                          (0x00000000)
#define NVC37E_SET_CONTROL_INPUT_LUT_OUTPUT_MODE_INTERPOLATE                    (0x00000001)
#define NVC37E_SET_OFFSET_INPUT_LUT                                             (0x000002B4)
#define NVC37E_SET_OFFSET_INPUT_LUT_ORIGIN                                      31:0
#define NVC37E_SET_CONTEXT_DMA_INPUT_LUT                                        (0x000002B8)
#define NVC37E_SET_CONTEXT_DMA_INPUT_LUT_HANDLE                                 31:0
#define NVC37E_SET_CSC_RED2RED                                                  (0x000002BC)
#define NVC37E_SET_CSC_RED2RED_COEFF                                            18:0
#define NVC37E_SET_CSC_GREEN2RED                                                (0x000002C0)
#define NVC37E_SET_CSC_GREEN2RED_COEFF                                          18:0
#define NVC37E_SET_CSC_BLUE2RED                                                 (0x000002C4)
#define NVC37E_SET_CSC_BLUE2RED_COEFF                                           18:0
#define NVC37E_SET_CSC_CONSTANT2RED                                             (0x000002C8)
#define NVC37E_SET_CSC_CONSTANT2RED_COEFF                                       18:0
#define NVC37E_SET_CSC_RED2GREEN                                                (0x000002CC)
#define NVC37E_SET_CSC_RED2GREEN_COEFF                                          18:0
#define NVC37E_SET_CSC_GREEN2GREEN                                              (0x000002D0)
#define NVC37E_SET_CSC_GREEN2GREEN_COEFF                                        18:0
#define NVC37E_SET_CSC_BLUE2GREEN                                               (0x000002D4)
#define NVC37E_SET_CSC_BLUE2GREEN_COEFF                                         18:0
#define NVC37E_SET_CSC_CONSTANT2GREEN                                           (0x000002D8)
#define NVC37E_SET_CSC_CONSTANT2GREEN_COEFF                                     18:0
#define NVC37E_SET_CSC_RED2BLUE                                                 (0x000002DC)
#define NVC37E_SET_CSC_RED2BLUE_COEFF                                           18:0
#define NVC37E_SET_CSC_GREEN2BLUE                                               (0x000002E0)
#define NVC37E_SET_CSC_GREEN2BLUE_COEFF                                         18:0
#define NVC37E_SET_CSC_BLUE2BLUE                                                (0x000002E4)
#define NVC37E_SET_CSC_BLUE2BLUE_COEFF                                          18:0
#define NVC37E_SET_CSC_CONSTANT2BLUE                                            (0x000002E8)
#define NVC37E_SET_CSC_CONSTANT2BLUE_COEFF                                      18:0
#define NVC37E_SET_COMPOSITION_CONTROL                                          (0x000002EC)
#define NVC37E_SET_COMPOSITION_CONTROL_COLOR_KEY_SELECT                         1:0
#define NVC37E_SET_COMPOSITION_CONTROL_COLOR_KEY_SELECT_DISABLE                 (0x00000000)
#define NVC37E_SET_COMPOSITION_CONTROL_COLOR_KEY_SELECT_SRC                     (0x00000001)
#define NVC37E_SET_COMPOSITION_CONTROL_COLOR_KEY_SELECT_DST                     (0x00000002)
#define NVC37E_SET_COMPOSITION_CONTROL_DEPTH                                    11:4
#define NVC37E_SET_COMPOSITION_CONSTANT_ALPHA                                   (0x000002F0)
#define NVC37E_SET_COMPOSITION_CONSTANT_ALPHA_K1                                7:0
#define NVC37E_SET_COMPOSITION_CONSTANT_ALPHA_K2                                15:8
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT                                    (0x000002F4)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_MATCH_SELECT      3:0
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_MATCH_SELECT_ZERO (0x00000000)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_MATCH_SELECT_ONE  (0x00000001)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_MATCH_SELECT_K1   (0x00000002)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_MATCH_SELECT_K1_TIMES_SRC (0x00000005)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_MATCH_SELECT_K1_TIMES_DST (0x00000006)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_MATCH_SELECT_NEG_K1_TIMES_DST (0x00000008)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_NO_MATCH_SELECT   7:4
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_NO_MATCH_SELECT_ZERO (0x00000000)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_NO_MATCH_SELECT_ONE (0x00000001)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_NO_MATCH_SELECT_K1 (0x00000002)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_NO_MATCH_SELECT_K1_TIMES_SRC (0x00000005)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_NO_MATCH_SELECT_K1_TIMES_DST (0x00000006)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_NO_MATCH_SELECT_NEG_K1_TIMES_DST (0x00000008)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT      11:8
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_ZERO (0x00000000)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_ONE  (0x00000001)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_K1   (0x00000002)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_K2   (0x00000003)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_NEG_K1 (0x00000004)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_K1_TIMES_DST (0x00000006)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_NEG_K1_TIMES_SRC (0x00000007)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_NEG_K1_TIMES_DST (0x00000008)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT   15:12
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_ZERO (0x00000000)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_ONE (0x00000001)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_K1 (0x00000002)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_K2 (0x00000003)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_NEG_K1 (0x00000004)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_K1_TIMES_DST (0x00000006)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_NEG_K1_TIMES_SRC (0x00000007)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_NEG_K1_TIMES_DST (0x00000008)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_MATCH_SELECT      19:16
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_MATCH_SELECT_ZERO (0x00000000)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_MATCH_SELECT_K1   (0x00000002)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_MATCH_SELECT_K2   (0x00000003)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_MATCH_SELECT_NEG_K1_TIMES_DST (0x00000008)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_NO_MATCH_SELECT   23:20
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_NO_MATCH_SELECT_ZERO (0x00000000)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_NO_MATCH_SELECT_K1 (0x00000002)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_NO_MATCH_SELECT_K2 (0x00000003)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_NO_MATCH_SELECT_NEG_K1_TIMES_DST (0x00000008)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_MATCH_SELECT      27:24
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_MATCH_SELECT_ZERO (0x00000000)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_MATCH_SELECT_ONE  (0x00000001)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_MATCH_SELECT_K2   (0x00000003)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_MATCH_SELECT_NEG_K1_TIMES_SRC (0x00000007)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_NO_MATCH_SELECT   31:28
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_NO_MATCH_SELECT_ZERO (0x00000000)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_NO_MATCH_SELECT_ONE (0x00000001)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_NO_MATCH_SELECT_K2 (0x00000003)
#define NVC37E_SET_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_NO_MATCH_SELECT_NEG_K1_TIMES_SRC (0x00000007)
#define NVC37E_SET_KEY_ALPHA                                                    (0x000002F8)
#define NVC37E_SET_KEY_ALPHA_MIN                                                15:0
#define NVC37E_SET_KEY_ALPHA_MAX                                                31:16
#define NVC37E_SET_KEY_RED_CR                                                   (0x000002FC)
#define NVC37E_SET_KEY_RED_CR_MIN                                               15:0
#define NVC37E_SET_KEY_RED_CR_MAX                                               31:16
#define NVC37E_SET_KEY_GREEN_Y                                                  (0x00000300)
#define NVC37E_SET_KEY_GREEN_Y_MIN                                              15:0
#define NVC37E_SET_KEY_GREEN_Y_MAX                                              31:16
#define NVC37E_SET_KEY_BLUE_CB                                                  (0x00000304)
#define NVC37E_SET_KEY_BLUE_CB_MIN                                              15:0
#define NVC37E_SET_KEY_BLUE_CB_MAX                                              31:16
#define NVC37E_SET_PRESENT_CONTROL                                              (0x00000308)
#define NVC37E_SET_PRESENT_CONTROL_MIN_PRESENT_INTERVAL                         3:0
#define NVC37E_SET_PRESENT_CONTROL_BEGIN_MODE                                   6:4
#define NVC37E_SET_PRESENT_CONTROL_BEGIN_MODE_NON_TEARING                       (0x00000000)
#define NVC37E_SET_PRESENT_CONTROL_BEGIN_MODE_IMMEDIATE                         (0x00000001)
#define NVC37E_SET_PRESENT_CONTROL_TIMESTAMP_MODE                               8:8
#define NVC37E_SET_PRESENT_CONTROL_TIMESTAMP_MODE_DISABLE                       (0x00000000)
#define NVC37E_SET_PRESENT_CONTROL_TIMESTAMP_MODE_ENABLE                        (0x00000001)
#define NVC37E_SET_INTERLOCK_FLAGS                                              (0x00000370)
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CORE                          0:0
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CORE_DISABLE                  (0x00000000)
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CORE_ENABLE                   (0x00000001)
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR(i)                     ((i)+1):((i)+1)
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR__SIZE_1                8
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR_DISABLE                (0x00000000)
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR_ENABLE                 (0x00000001)
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR0                       1:1
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR0_DISABLE               (0x00000000)
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR0_ENABLE                (0x00000001)
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR1                       2:2
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR1_DISABLE               (0x00000000)
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR1_ENABLE                (0x00000001)
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR2                       3:3
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR2_DISABLE               (0x00000000)
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR2_ENABLE                (0x00000001)
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR3                       4:4
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR3_DISABLE               (0x00000000)
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR3_ENABLE                (0x00000001)
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR4                       5:5
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR4_DISABLE               (0x00000000)
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR4_ENABLE                (0x00000001)
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR5                       6:6
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR5_DISABLE               (0x00000000)
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR5_ENABLE                (0x00000001)
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR6                       7:7
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR6_DISABLE               (0x00000000)
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR6_ENABLE                (0x00000001)
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR7                       8:8
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR7_DISABLE               (0x00000000)
#define NVC37E_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR7_ENABLE                (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS                                       (0x00000374)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW(i)              ((i)+0):((i)+0)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW__SIZE_1         32
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW_DISABLE         (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW_ENABLE          (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW0                0:0
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW0_DISABLE        (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW0_ENABLE         (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW1                1:1
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW1_DISABLE        (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW1_ENABLE         (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW2                2:2
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW2_DISABLE        (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW2_ENABLE         (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW3                3:3
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW3_DISABLE        (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW3_ENABLE         (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW4                4:4
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW4_DISABLE        (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW4_ENABLE         (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW5                5:5
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW5_DISABLE        (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW5_ENABLE         (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW6                6:6
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW6_DISABLE        (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW6_ENABLE         (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW7                7:7
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW7_DISABLE        (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW7_ENABLE         (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW8                8:8
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW8_DISABLE        (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW8_ENABLE         (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW9                9:9
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW9_DISABLE        (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW9_ENABLE         (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW10               10:10
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW10_DISABLE       (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW10_ENABLE        (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW11               11:11
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW11_DISABLE       (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW11_ENABLE        (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW12               12:12
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW12_DISABLE       (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW12_ENABLE        (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW13               13:13
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW13_DISABLE       (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW13_ENABLE        (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW14               14:14
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW14_DISABLE       (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW14_ENABLE        (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW15               15:15
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW15_DISABLE       (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW15_ENABLE        (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW16               16:16
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW16_DISABLE       (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW16_ENABLE        (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW17               17:17
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW17_DISABLE       (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW17_ENABLE        (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW18               18:18
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW18_DISABLE       (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW18_ENABLE        (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW19               19:19
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW19_DISABLE       (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW19_ENABLE        (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW20               20:20
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW20_DISABLE       (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW20_ENABLE        (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW21               21:21
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW21_DISABLE       (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW21_ENABLE        (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW22               22:22
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW22_DISABLE       (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW22_ENABLE        (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW23               23:23
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW23_DISABLE       (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW23_ENABLE        (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW24               24:24
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW24_DISABLE       (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW24_ENABLE        (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW25               25:25
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW25_DISABLE       (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW25_ENABLE        (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW26               26:26
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW26_DISABLE       (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW26_ENABLE        (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW27               27:27
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW27_DISABLE       (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW27_ENABLE        (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW28               28:28
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW28_DISABLE       (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW28_ENABLE        (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW29               29:29
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW29_DISABLE       (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW29_ENABLE        (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW30               30:30
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW30_DISABLE       (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW30_ENABLE        (0x00000001)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW31               31:31
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW31_DISABLE       (0x00000000)
#define NVC37E_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW31_ENABLE        (0x00000001)
#endif // _clC37e_h
